/*
 */
package cmsc420project4;

import java.util.LinkedList;
import java.util.Queue;

/**
 * Main Controller class following the MVC architecture.
 * @author Jeremiah
 */
public class Controller
{

    private SheetUI UI;
    private SheetArray sheet;
    private DirectedGraph graph;

    public Controller(SheetUI UI, SheetArray sheet)
    {
	this.UI = UI;
	this.sheet = sheet;

	graph = new DirectedGraph();
    }

    // User has changed a cell, re-compute and return result.
    public String setString(int x, int y, String cellString)
    {
	// Everything wrapped in a try/catch to route errors to UI and output.
	try
	{
	    if (cellString.equals("") || cellString == null)
	    {
		removeCell(x, y);
		sheet.setOriginal(x, y, "");
		sheet.setResult(x, y, "");
		UI.setStatus("Cell cleared.");
		return "";
		//throw new RuntimeException("KABOOM");
	    }
	    removeCell(x, y);
	    sheet.setOriginal(x, y, cellString);

	    if (cellString.charAt(0) == '"')
	    {
		// It's a string.
		sheet.setCell(x, y, new CellString(cellString.substring(1)));
		sheet.setResult(x, y, cellString.substring(1));
	    } else if (cellString.charAt(0) == '+')
	    {
		// It's a formula
		Formula formula = new Formula(cellString.substring(1), this);


		// Create new node if there isn't one already.
		if (sheet.getNode(x, y) == null)
		{
		    sheet.setNode(x, y, new DirectedNode<CellReference>(new CellReference(x, y)));
		    graph.addNode(sheet.getNode(x, y));
		    System.out.println("Node added");
		}

		Queue<DirectedNode> newRefs = formula.getNewReferences();

		// add this cell to the inNodes of other cells.
		while (!newRefs.isEmpty())
		{
		    DirectedNode tempNode = newRefs.remove();
		    tempNode.addInNode(sheet.getNode(x, y));
		    System.out.println("ref added");
		}

		Queue<DirectedNode> computeOrder = new LinkedList<DirectedNode>();

		try
		{
		    computeOrder = graph.getSortedNodes();
		} catch (CycleFoundException ex)
		{
		    UI.setStatus("ERROR: Cycles not allowed.");
		    sheet.setResult(x, y, "#ERR#");
		    return "#ERR#";
		}

		sheet.setCell(x, y, formula);
		sheet.setResult(x, y, "Computing");

		// Recompute formulas in the proper order using a topologically sorted directed graph.
		// Theoretically, this should work. There seems to be a bug, however,
		// and only the current cell is updated.
		while (!computeOrder.isEmpty())
		{
		    System.out.println("Formula found");
		    DirectedNode<CellReference> node = computeOrder.remove();
		    CellReference ref = node.getData();
		    Formula newFormula = new Formula(sheet.getOriginal(ref.getX(), ref.getY()).substring(1), this);
		    sheet.setResult(ref.getX(), ref.getY(), newFormula.getResultString());
		}

		// Compute result
		//sheet.setResult(x, y, "" + formula.getResult());
	    } else if (cellString.charAt(0) == '=')
	    {
		// It's a function call
		Function func = new Function(cellString.substring(1), this);
		sheet.setResult(x, y, Double.toString(func.getResult()));
		return Double.toString(func.getResult());
	    } else
	    {
		throw new RuntimeException("Cells must begin with \", +, or =");
	    }

	    UI.setStatus("Value accepted.");
	    return sheet.getResult(x, y);
	} catch (RuntimeException e)
	{
	    sheet.setResult(x, y, "#ERR#");
	    UI.setStatus("ERROR: " + e.toString());
//	    UI.updateCell(x, y);
	    e.printStackTrace(System.err);
	    return "#ERR#";
	    //throw e;
	}
    }

    public Double getCellResult(int x, int y)
    {
	try
	{
	    String original = sheet.getOriginal(x, y);
	    System.out.println(sheet.getOriginal(x, y));
	    Double result = Double.NaN;
	    if (original.startsWith("\""))
	    {
		//result = new Result<String>(Result.ResultTypes.STRING);
		//result.setData(original.substring(1));
		//TODO: Double conversion.
		try
		{
		    return Double.parseDouble(original.substring(1));
		} catch (NumberFormatException e)
		{
		}
		return Double.NaN;
	    } else if (original.startsWith("+"))
	    {
		Formula formula = new Formula(original.substring(1), this);
		result = formula.getResult();
	    } else if (original.startsWith("="))
	    {
		Function func = new Function(original.substring(1), this);
//	    throw new RuntimeException("Not implemented yet!");
	    } else if (original.equals("") || original == null)
	    {
		return null;
	    } else
	    {
		throw new RuntimeException("Invalid cell value (" + original + ")");
	    }
	    return result;
	} catch (RuntimeException e)
	{
	    sheet.setResult(x, y, "#ERR#");
	    UI.setStatus("ERROR: " + e.toString());
//	    UI.updateCell(x, y);
	    e.printStackTrace(System.err);
	    return Double.NaN;
	    //throw e;
	}
    }

    // Get original value user entered.
    public String getEditableValue(int x, int y)
    {
	return sheet.getOriginal(x, y);
    }

    private void removeCell(int x, int y)
    {
	// Remove cell at x, y. Formulas may need to be removed from the directed graph.
    }
}
